package com.swvoitures.reservation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.util.Random;

/*
* La classe <code>CarAvailability</code> gre les donnes
* d'une disponibilit de la centrale de rservation automobile
* SW-Voitures. 
*
* @version  1.0
*/
public class CarAvailability {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private String carRentalCompany = "";
	private String carCategory = "";
	private String carModel = "";
	private float pricePerWeek = 0;
	private float pricePerDay = 0;

	private int remoteId = 0;
	
	private Writer writer;

	/*
	* Le constructeur de disponibilit de la centrale de
	* rservation automobile.
	*/
	public CarAvailability() {
		getId();
		try {
			writer = new BufferedWriter(new OutputStreamWriter(System.out, "Cp850"));
		}
		catch(UnsupportedEncodingException e) {
			writer = new BufferedWriter(new OutputStreamWriter(System.out));
		}
	}

	/*
	* Renvoie l'identifiant de la disponibilit.
	*/
	public synchronized int getId() {
		if (id == 0) {
			id = idGenerator.nextInt();
		}
		setRemoteId(id);
		return id;
	}

	/*
	* Renvoie l'identifiant de la disponibilit
	* du partenaire.
	*/
	public int getRemoteId() {
		return this.remoteId;
	}

	/*
	* Affecte l'identifiant de la disponibilit
	* du partenaire.
	*
	* @param		remoteId l'identifiant de la 
	*				disponibilit du partenaire
	*/
	public void setRemoteId(int remoteId) {
		this.remoteId = remoteId;
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* rservation effectue par l'utilisateur.
	*/
	public void status() {

		StringBuffer sb = new StringBuffer();
		sb.append("\n socit de location : ");
		sb.append(getCarRentalCompany());
		sb.append("\n catgorie du vhicule : ");
		sb.append(getCarCategory());
		sb.append("\n modle du vhicule : ");
		sb.append(getCarModel());
		sb.append("\n prix par semaine : ");
		sb.append(getPricePerWeek());
		sb.append("\n prix par jour : ");
		sb.append(getPricePerDay());
		sb.append("\n");
		try {
			writer.write(sb.toString());
			writer.flush();
		}
		catch(IOException e) {
			System.out.println(sb);
		}
	}

	/*
	* Renvoie le nom de la socit de location
	* de vhicules.
	*/
	public String getCarRentalCompany() {
		return carRentalCompany;
	}

	/*
	* Affecte le nom de la socit de location
	* de vhicules.
	*
	* @param		carRentalCompany le nom de la socit
	* 				de location de vhicules.
	*/
	public void setCarRentalCompany(String carRentalCompany) {
		this.carRentalCompany = carRentalCompany;
	}

	/*
	* Renvoie la catgorie de vhicule.
	*/
	public String getCarCategory() {
		return carCategory;
	}

	/*
	* Affecte la catgorie de vhicule.
	*
	* @param		carCategory la catgorie de vhicule
	*/
	public void setCarCategory(String carCategory) {
		this.carCategory = carCategory;
	}

	/*
	* Renvoie le modle du vhicule.
	*/
	public String getCarModel() {
		return carModel;
	}

	/*
	* Affecte le modle du vhicule.
	*
	* @param		carModel le modle du vhicule
	*/
	public void setCarModel(String carModel) {
		this.carModel = carModel;
	}

	/*
	* Renvoie le prix de rservation par semaine.
	*/
	public float getPricePerWeek() {
		return pricePerWeek;
	}

	/*
	* Affecte le prix de rservation par semaine.
	*
	* @param		pricePerWeek le prix par semaine
	*/
	public void setPricePerWeek(float pricePerWeek) {
		this.pricePerWeek = pricePerWeek;
	}

	/*
	* Renvoie le prix de rservation par jour.
	*/
	public float getPricePerDay() {
		return pricePerDay;
	}

	/*
	* Affecte le prix de rservation par jour.
	*
	* @param		pricePerDay le prix par jour
	*/
	public void setPricePerDay(float pricePerDay) {
		this.pricePerDay = pricePerDay;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* disponibilit du partenaire. 
	*
	* @return		une reprsentation textuelle de la
	* 				disponibilit.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}